/******************************************************************************
 x_CLibrary.c

				CLibrary Document Class
	

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.


	Generated by Classy (Object Factory) 7:41 PM Mon, Oct 4, 1993

	This file is rewritten each time you generate code. You should not
	make changes to this file; changes should go in the My.c
	file, instead.

	If you want to change how Classy generates this file, you can
	change the template for this file. It is "_Doc.c" in the Classy
	Templates folder.

 ******************************************************************************/

#include "x_CLibrary.h"

#include "CLibrary.h"

#include "LibraryItems.h"

#include "ViewUtilities.h"
#include "CAdaApp.h"

#include <CApplication.h>
#include <CBartender.h>
#include <Commands.h>
#include <Constants.h>
#include <CDecorator.h>
#include <CDesktop.h>
#include <CFile.h>
#include <TBUtilities.h>
#include <CWindow.h>

extern	CApplication *gApplication;		/* The application					*/
extern CDecorator	*gDecorator;		/* Decorator for arranging windows	*/
extern CDesktop		*gDesktop;			/* The visible Desktop				*/
extern CBartender	*gBartender;		/* Manages all menus				*/

#include "CButtonProc.h"
#include "CUnits.h"
#include "CStaticText.h"

	// Define symbols for commands handled by this class
	// Prevents a recompile every time any command changed.

#define cmdInitializeLibrary 556

/**** C O N S T R U C T I O N / D E S T R U C T I O N   M E T H O D S ****/


/******************************************************************************
 Ix_CLibrary

	Initialize the document
 ******************************************************************************/

void x_CLibrary::Ix_CLibrary()

{
	IDocument(gApplication, TRUE);

		// Initialize data members below.
}


/******************************************************************************
 MakeNewWindow

	Create a new, empty window.  Subclass may override to populate
	the new window.
 ******************************************************************************/

void x_CLibrary::MakeNewWindow(void)

{
	itsWindow = CLGetNamedWindow("\pLibrary", this);
	
	itsMainPane = (CPane*) GetItemPointer(itsWindow, 0);

		// Initialize pointers to the subpanes in the window

  fLibrary_Bind = (CButtonProc*) itsWindow->FindViewByID(kLibrary_BindID);
  ASSERT(member(fLibrary_Bind, CButtonProc));

  fLibrary_Execute = (CButtonProc*) itsWindow->FindViewByID(kLibrary_ExecuteID);
  ASSERT(member(fLibrary_Execute, CButtonProc));

  fLibrary_Units = (CUnits*) itsWindow->FindViewByID(kLibrary_UnitsID);
  ASSERT(member(fLibrary_Units, CUnits));

  fLibrary_Stat14 = (CStaticText*) itsWindow->FindViewByID(kLibrary_Stat14ID);
  ASSERT(member(fLibrary_Stat14, CStaticText));

  fLibrary_Stat15 = (CStaticText*) itsWindow->FindViewByID(kLibrary_Stat15ID);
  ASSERT(member(fLibrary_Stat15, CStaticText));

  fLibrary_Stat16 = (CStaticText*) itsWindow->FindViewByID(kLibrary_Stat16ID);
  ASSERT(member(fLibrary_Stat16, CStaticText));

  fLibrary_Stat17 = (CStaticText*) itsWindow->FindViewByID(kLibrary_Stat17ID);
  ASSERT(member(fLibrary_Stat17, CStaticText));

}


/******************************************************************************
 FailOpen {OVERRIDE}

		Fail if file already open in this application.
		
		This function calls the application's FileAlreadyOpen function
		and fails quietly if the file is open.

		Note that open may also fail if the file is open in
		another application. This will cause a failure in open,
		but you may wish to override this function to detect this
		case and provide a more meaningful error message than -49.
 ******************************************************************************/

void	x_CLibrary::FailOpen(
	CFile	*aFile)

{
										/* Only the application knows		*/
	if (((CAdaApp*)gApplication)->FileAlreadyOpen(aFile))
		Failure(kSilentErr, 0);
}


/******************************************************************************
 PositionWindow

	The default method in CSaver calls the the decorator, which
	staggers and resizes the window. Since the window has already
	been positioned when it is initialized from the view resource,
	we don't want to do this twice.
 ******************************************************************************/

void	x_CLibrary::PositionWindow()

{
}




/******************************************************************************
 DoCommand {OVERRIDE}

		Dispatch Classy-specified actions.
 ******************************************************************************/

void x_CLibrary::DoCommand(long theCommand)

{
	switch (theCommand)
	{
		case cmdInitializeLibrary:
			break;
		default:
			CDocument::DoCommand(theCommand);
	}
}


/******************************************************************************
 UpdateMenus {OVERRIDE}

		Enable menus which generate commands handled by this class.
 ******************************************************************************/

void x_CLibrary::UpdateMenus()

{
	CDocument::UpdateMenus();
	gBartender->EnableCmd(cmdInitializeLibrary);
}


